# Setup View

The Setup View is used to configure a new vehicle prior to first flight and/or tune a configured vehicle.

![](../../../assets/setup/setup_view.jpg)

## Setup Options

To the left of the screen are the set of available setup options. A setup button is marked with a red icon if there are still settings needed to be adjusted/specified. You should not fly if any of these are red. In the above image the Radio setup is not yet complete.

:::info
The set of options shown and the contents of each option may differ based on whether the vehicle is running PX4 Pro or ArduPilot firmware. The image above is from a vehicle which is running PX4 Pro firmware.
:::

**Summary** <br />An overview of all the important setup options for your vehicle. Similar to the individual setup buttons, the summary blocks show a red indicator when those settings are not fully configured.

**[Firmware](firmware.md)** <br />Flash new firmware onto your vehicle.

**[Airframe](airframe.md)** <br />Specify the airframe type for the vehicle.

**[Radio](radio.md)** <br />Calibrate your Radio Control Transmitter.

**[Sensors](sensors.md)** <br />Calibrate the sensors on the vehicle.

**[Flight Modes](flight_modes.md)** <br />Used to assign flight modes to your RC Transmitter switches.

**[Power](power.md)** <br />Battery settings and additional power options such as ESC calibration.

**[Motors](motors.md)** <br />Motors testing and setup.

**[Safety](Safety.md)** <br />Specify settings for options related to Safety such as Return to Home or Failsafes.

**[Tuning](tuning.md)** <br />Tune flight characteristics of the vehicle.

**[Camera](camera.md)** <br />Configure settings for camera and gimbal.

**[Parameters](parameters.md)** <br />Allows you to modify all parameters associated with your vehicle. <br /> <br />
