# Sidebar

- [Overview](qgc-user-guide/index.md)
  - [Quick Start](qgc-user-guide/getting_started/quick_start.md)
  - [Download and Install](qgc-user-guide/getting_started/download_and_install.md)
  - [Toolbar/Menu](qgc-user-guide/toolbar/toolbar.md)
  - [Support](qgc-user-guide/support/support.md)
- [Fly](qgc-user-guide/fly_view/fly_view.md)
  - [Replay Flight Data](qgc-user-guide/fly_view/replay_flight_data.md)
  - [Video Overlay](qgc-user-guide/fly_view/video_overlay.md)
- [Plan](qgc-user-guide/plan_view/plan_view.md)
  - [GeoFence](qgc-user-guide/plan_view/plan_geofence.md)
  - [Rally Points](qgc-user-guide/plan_view/plan_rally_points.md)
  - [Pattern](qgc-user-guide/plan_view/pattern.md)
    - [Survey](qgc-user-guide/plan_view/pattern_survey.md)
    - [Structure Scan](qgc-user-guide/plan_view/pattern_structure_scan_v2.md)
    - [Corridor Scan](qgc-user-guide/plan_view/pattern_corridor_scan.md)
    - [Fixed Wing Landing Pattern](qgc-user-guide/plan_view/pattern_fixed_wing_landing.md)
    - [Pattern Presets](qgc-user-guide/plan_view/pattern_presets.md)
- [Vehicle Setup](qgc-user-guide/setup_view/setup_view.md)
  - [Firmware](qgc-user-guide/setup_view/firmware.md)
  - [Airframe](qgc-user-guide/setup_view/airframe.md)
    - [Airframe (ArduPilot)](qgc-user-guide/setup_view/airframe_ardupilot.md)
    - [Airframe (PX4)](qgc-user-guide/setup_view/airframe_px4.md)
  - [Radio](qgc-user-guide/setup_view/radio.md)
  - [Sensors](qgc-user-guide/setup_view/sensors.md)
    - [Sensors (ArduPilot)](qgc-user-guide/setup_view/sensors_ardupilot.md)
    - [Sensors (PX4)](qgc-user-guide/setup_view/sensors_px4.md)
  - [Flight Modes](qgc-user-guide/setup_view/flight_modes.md)
    - [ArduPilot Flight Modes Setup](qgc-user-guide/setup_view/flight_modes_ardupilot.md)
    - [PX4 Flight Modes Setup](qgc-user-guide/setup_view/flight_modes_px4.md)
  - [Power](qgc-user-guide/setup_view/power.md)
  - [Motors](qgc-user-guide/setup_view/motors.md)
    - [Motors (ArduSub)](qgc-user-guide/setup_view/motors_ardusub.md)
  - [Safety](qgc-user-guide/setup_view/safety.md)
    - [Safety (ArduPilot)](qgc-user-guide/setup_view/safety_ardupilot.md)
  - [Tuning](qgc-user-guide/setup_view/tuning.md)
    - [Tuning (ArduPilot)](qgc-user-guide/setup_view/tuning_ardupilot.md)
      - [ArduCopter Tuning](qgc-user-guide/setup_view/tuning_arducopter.md)
      - [ArduSub Tuning](qgc-user-guide/setup_view/tuning_ardusub.md)
    - [Tuning (PX4)](qgc-user-guide/setup_view/tuning_px4.md)
  - [Camera](qgc-user-guide/setup_view/camera.md)
  - [Joystick](qgc-user-guide/setup_view/joystick.md)
  - [Parameters](qgc-user-guide/setup_view/parameters.md)
- [Application Settings](qgc-user-guide/settings_view/settings_view.md)
  - [General](qgc-user-guide/settings_view/general.md)
    - [CSV Logging](qgc-user-guide/settings_view/csv.md)
  - [Offline Maps](qgc-user-guide/settings_view/offline_maps.md)
  - [MAVLink](qgc-user-guide/settings_view/mavlink.md)
  - [Console Logging](qgc-user-guide/settings_view/console_logging.md)
  - [Virtual Joystick (PX4)](qgc-user-guide/settings_view/virtual_joystick.md)
- [Analyze](qgc-user-guide/analyze_view/index.md)
  - [Log Download](qgc-user-guide/analyze_view/log_download.md)
  - [GeoTag Images (PX4)](qgc-user-guide/analyze_view/geotag_images.md)
  - [MAVLink Console (PX4)](qgc-user-guide/analyze_view/mavlink_console.md)
  - [MAVLink Inspector](qgc-user-guide/analyze_view/mavlink_inspector.md)
- [Releases](qgc-user-guide/releases/index.md)
  - [Release Notes](qgc-user-guide/releases/release_notes.md)
    - [v4.0 (Additional Notes)](qgc-user-guide/releases/stable_v4.0_additional.md)
    - [v3.3 (Detailed)](qgc-user-guide/releases/stable_v3.3_long.md)
    - [v3.2 (Detailed)](qgc-user-guide/releases/stable_v3.2_long.md)
  - [Daily Builds](qgc-user-guide/releases/daily_builds.md)
  - [Daily Build New Features](qgc-user-guide/releases/daily_build_new_features.md)
  - [Privacy Policy](qgc-user-guide/releases/privacy_policy.md)
- [Troubleshooting](qgc-user-guide/troubleshooting/index.md)

  - [Setup Problems](qgc-user-guide/troubleshooting/qgc_setup.md)
  - [Usage Problems](qgc-user-guide/troubleshooting/qgc_usage.md)
    - [Connection problems](qgc-user-guide/troubleshooting/vehicle_connection.md)
    - [Parameter Download failures](qgc-user-guide/troubleshooting/parameter_download.md)
    - [Plan Upload/Download failures](qgc-user-guide/troubleshooting/plan_upload_download.md)
    - [Resume Mission failures](qgc-user-guide/troubleshooting/resume_mission.md)

- [Developer's Guide](qgc-dev-guide/index.md)
  - [Getting Started with source & builds](qgc-dev-guide/getting_started/index.md)
    - [Build using Containers](qgc-dev-guide/getting_started/container.md)
    - [Using QGC on CentOS](qgc-dev-guide/getting_started/cent_os.md)
  - [QGC Release/Branching Process](qgc-dev-guide/release_branching_process.md)
  - [Communication Flow](qgc-dev-guide/communication_flow.md)
  - [Plugin Architecture](qgc-dev-guide/firmware_plugin.md)
  - [Class Hierarchy](qgc-dev-guide/classes/index.md)
  - [User Interface Design](qgc-dev-guide/user_interface_design/index.md)
    - [Multi-Device Design Pattern](qgc-dev-guide/user_interface_design/multi_device_pattern.md)
    - [Font and Colour Palette](qgc-dev-guide/user_interface_design/font_palette.md)
    - [UI Controls](qgc-dev-guide/user_interface_design/controls.md)
  - [Fact System](qgc-dev-guide/fact_system.md)
  - [Top Level Views](qgc-dev-guide/views/index.md)
    - [Settings View](qgc-dev-guide/views/settings.md)
    - [Setup View](qgc-dev-guide/views/setup.md)
    - [Plan View](qgc-dev-guide/views/plan.md)
      - [Dynamic UI for mission item editing](qgc-dev-guide/plan/mission_command_tree.md)
    - [Fly View](qgc-dev-guide/views/fly.md)
  - [File Formats](qgc-dev-guide/file_formats/index.md)
    - [Parameters](qgc-dev-guide/file_formats/parameters.md)
    - [Plan](qgc-dev-guide/file_formats/plan.md)
    - [MAVLink Logs](qgc-dev-guide/file_formats/mavlink.md)
  - [Developer Tools](qgc-dev-guide/tools/index.md)
    - [Mock Link](qgc-dev-guide/tools/mock_link.md)
  - [Command Line Options](qgc-dev-guide/command_line_options.md)
  - [Custom Builds](qgc-dev-guide/custom_build/custom_build.md)
    - [Initial Repository Setup For Custom Build](qgc-dev-guide/custom_build/create_repos.md)
    - [Custom Build Plugins](qgc-dev-guide/custom_build/plugins.md)
    - [Resources Overrides](qgc-dev-guide/custom_build/resource_override.md)
    - [Customization](qgc-dev-guide/custom_build/customization.md)
      - [First Run Prompts](qgc-dev-guide/custom_build/first_run_prompts.md)
      - [Toolbar customization](qgc-dev-guide/custom_build/toolbar.md)
      - [Fly View Customization](qgc-dev-guide/custom_build/fly_view.md)
    - [Release/Branching Process For Custom Builds](qgc-dev-guide/custom_build/release_branching_process.md)
    - [MAVLink](qgc-dev-guide/custom_build/mavlink.md)
  - [Code Submission](qgc-dev-guide/contribute/index.md)
    - [Developer Call](qgc-dev-guide/contribute/dev_call.md)
    - [Coding Style](qgc-dev-guide/contribute/coding_style.md)
    - [Unit Tests](qgc-dev-guide/contribute/unit_tests.md)
    - [Pull Requests](qgc-dev-guide/contribute/pull_requests.md)
    - [Licenses](qgc-dev-guide/contribute/licences.md)
