/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx.ft4222;

import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.ft4222.FT_4222_Device;
import com.ftdi.j2xx.interfaces.I2cMaster;

public class FT_4222_I2c_Master
implements I2cMaster {
    FT_4222_Device mFt4222Dev;
    FT_Device mFtDev;
    int mI2cMasterKbps;

    public FT_4222_I2c_Master(FT_4222_Device ft4222Device) {
        this.mFt4222Dev = ft4222Device;
        this.mFtDev = this.mFt4222Dev.mFtDev;
    }

    int cmdSet(int wValue1, int wValue2) {
        return this.mFtDev.VendorCmdSet(33, wValue1 | wValue2 << 8);
    }

    int cmdSet(int wValue1, int wValue2, byte[] buf, int datalen) {
        return this.mFtDev.VendorCmdSet(33, wValue1 | wValue2 << 8, buf, datalen);
    }

    int cmdGet(int wValue1, int wValue2, byte[] buf, int datalen) {
        return this.mFtDev.VendorCmdGet(32, wValue1 | wValue2 << 8, buf, datalen);
    }

    public int init(int kbps) {
        byte[] clk = new byte[1];
        int ftStatus = this.mFt4222Dev.init();
        if (ftStatus != 0) {
            return ftStatus;
        }
        if (!this.I2C_Mode_Check()) {
            return 1012;
        }
        this.cmdSet(81, 0);
        ftStatus = this.mFt4222Dev.getClock(clk);
        if (ftStatus != 0) {
            return ftStatus;
        }
        int i2cMP = this.i2c_master_setup_timer_period(clk[0], kbps);
        ftStatus = this.cmdSet(5, 1);
        if (ftStatus < 0) {
            return ftStatus;
        }
        this.mFt4222Dev.mChipStatus.function = 1;
        ftStatus = this.cmdSet(82, i2cMP);
        if (ftStatus < 0) {
            return ftStatus;
        }
        this.mI2cMasterKbps = kbps;
        return 0;
    }

    public int reset() {
        int reset = 1;
        int ftStatus = this.I2C_Check(true);
        if (ftStatus != 0) {
            return ftStatus;
        }
        return this.cmdSet(81, reset);
    }

    public int read(int deviceAddress, byte[] buffer, int sizeToTransfer, int[] sizeTransferred) {
        return this.readEx(deviceAddress, 6, buffer, sizeToTransfer, sizeTransferred);
    }

    public int readEx(int deviceAddress, int flag, byte[] buffer, int sizeToTransfer, int[] sizeTransferred) {
        short slave_addr = (short)(deviceAddress & 0xFFFF);
        short shortSizeToTransfer = (short)sizeToTransfer;
        int[] maxSize = new int[1];
        byte[] headBuf = new byte[4];
        long startTime = System.currentTimeMillis();
        int iTimeout = this.mFtDev.getReadTimeout();
        int ftStatus = this.I2C_Version_Check(flag);
        if (ftStatus != 0) {
            return ftStatus;
        }
        ftStatus = this.I2C_Address_Check(deviceAddress);
        if (ftStatus != 0) {
            return ftStatus;
        }
        if (sizeToTransfer < 1) {
            return 6;
        }
        ftStatus = this.I2C_Check(true);
        if (ftStatus != 0) {
            return ftStatus;
        }
        ftStatus = this.getMaxTransferSize(maxSize);
        if (ftStatus != 0) {
            return ftStatus;
        }
        if (sizeToTransfer > maxSize[0]) {
            return 1010;
        }
        sizeTransferred[0] = 0;
        slave_addr = (short)((slave_addr << 1) + 1);
        headBuf[0] = (byte)slave_addr;
        headBuf[1] = (byte)flag;
        headBuf[2] = (byte)(shortSizeToTransfer >> 8 & 0xFF);
        headBuf[3] = (byte)(shortSizeToTransfer & 0xFF);
        ftStatus = this.mFtDev.write(headBuf, 4);
        if (4 != ftStatus) {
            return 1011;
        }
        int dataSize = this.mFtDev.getQueueStatus();
        while (dataSize < sizeToTransfer && System.currentTimeMillis() - startTime < (long)iTimeout) {
            dataSize = this.mFtDev.getQueueStatus();
        }
        if (dataSize > sizeToTransfer) {
            dataSize = sizeToTransfer;
        }
        sizeTransferred[0] = ftStatus = this.mFtDev.read(buffer, dataSize);
        if (ftStatus >= 0) {
            return 0;
        }
        return 1011;
    }

    public int write(int deviceAddress, byte[] buffer, int sizeToTransfer, int[] sizeTransferred) {
        return this.writeEx(deviceAddress, 6, buffer, sizeToTransfer, sizeTransferred);
    }

    public int writeEx(int deviceAddress, int flag, byte[] buffer, int sizeToTransfer, int[] sizeTransferred) {
        short slave_addr = (short)deviceAddress;
        short shortSizeToTransfer = (short)sizeToTransfer;
        byte[] transferBuf = new byte[sizeToTransfer + 4];
        int[] maxSize = new int[1];
        int ftStatus = this.I2C_Version_Check(flag);
        if (ftStatus != 0) {
            return ftStatus;
        }
        ftStatus = this.I2C_Address_Check(deviceAddress);
        if (ftStatus != 0) {
            return ftStatus;
        }
        if (sizeToTransfer < 1) {
            return 6;
        }
        ftStatus = this.I2C_Check(true);
        if (ftStatus != 0) {
            return ftStatus;
        }
        ftStatus = this.getMaxTransferSize(maxSize);
        if (ftStatus != 0) {
            return ftStatus;
        }
        if (sizeToTransfer > maxSize[0]) {
            return 1010;
        }
        sizeTransferred[0] = 0;
        slave_addr = (short)(slave_addr << 1);
        transferBuf[0] = (byte)slave_addr;
        transferBuf[1] = (byte)flag;
        transferBuf[2] = (byte)(shortSizeToTransfer >> 8 & 0xFF);
        transferBuf[3] = (byte)(shortSizeToTransfer & 0xFF);
        int i = 0;
        while (i < sizeToTransfer) {
            transferBuf[i + 4] = buffer[i];
            ++i;
        }
        ftStatus = this.mFtDev.write(transferBuf, sizeToTransfer + 4);
        sizeTransferred[0] = ftStatus - 4;
        if (sizeToTransfer == sizeTransferred[0]) {
            return 0;
        }
        return 10;
    }

    public int getStatus(int deviceAddress, byte[] controllerStatus) {
        int ftStatus = this.I2C_Check(true);
        if (ftStatus != 0) {
            return ftStatus;
        }
        ftStatus = this.mFtDev.VendorCmdGet(34, 62900, controllerStatus, 1);
        if (ftStatus < 0) {
            return 18;
        }
        return 0;
    }

    boolean I2C_Mode_Check() {
        return this.mFt4222Dev.mChipStatus.chip_mode == 0 || this.mFt4222Dev.mChipStatus.chip_mode == 3;
    }

    int I2C_Check(boolean isMaster) {
        if (isMaster ? this.mFt4222Dev.mChipStatus.function != 1 : this.mFt4222Dev.mChipStatus.function != 2) {
            return 1004;
        }
        return 0;
    }

    int I2C_Version_Check(int flag) {
        if (this.mFtDev == null || !this.mFtDev.isOpen()) {
            return 3;
        }
        if (flag != 6) {
            char[] fwVer = new char[1];
            this.getFWVersion(fwVer);
            if (fwVer[0] < 'B') {
                return 1022;
            }
        }
        return 0;
    }

    int I2C_Address_Check(int deviceAddress) {
        if ((deviceAddress & 0xFC00) > 0) {
            return 1007;
        }
        return 0;
    }

    private int i2c_master_setup_timer_period(int CLK_CTRL, int kbps) {
        int I2CMTP;
        double CLK_PRD;
        switch (CLK_CTRL) {
            default: {
                CLK_PRD = 16.666666666666668;
                break;
            }
            case 1: {
                CLK_PRD = 41.666666666666664;
                break;
            }
            case 2: {
                CLK_PRD = 20.833333333333332;
                break;
            }
            case 3: {
                CLK_PRD = 12.5;
            }
        }
        if (60 <= kbps && kbps <= 100) {
            int SCL_LP = 2;
            int SCL_HP = 2;
            double SCL_PERIOD = 1000000.0 / (double)kbps;
            int TIMER_PRD = (int)(SCL_PERIOD / (8.0 * CLK_PRD) - 1.0 + 0.5);
            if (TIMER_PRD > 127) {
                TIMER_PRD = 127;
            }
            I2CMTP = TIMER_PRD;
        } else if (100 < kbps && kbps <= 400) {
            int TIMER_PRD;
            int SCL_LP = 2;
            boolean SCL_HP = true;
            double SCL_PERIOD = 1000000.0 / (double)kbps;
            I2CMTP = TIMER_PRD = (int)(SCL_PERIOD / (6.0 * CLK_PRD) - 1.0 + 0.5);
            I2CMTP |= 0xC0;
        } else if (400 < kbps && kbps <= 1000) {
            int TIMER_PRD;
            int SCL_LP = 2;
            boolean SCL_HP = true;
            double SCL_PERIOD = 1000000.0 / (double)kbps;
            I2CMTP = TIMER_PRD = (int)(SCL_PERIOD / (6.0 * CLK_PRD) - 1.0 + 0.5);
            I2CMTP |= 0xC0;
        } else if (1000 < kbps && kbps <= 3400) {
            int TIMER_PRD;
            int SCL_LP = 2;
            boolean SCL_HP = true;
            double SCL_PERIOD = 1000000.0 / (double)kbps;
            I2CMTP = TIMER_PRD = (int)(SCL_PERIOD / (6.0 * CLK_PRD) - 1.0 + 0.5);
            I2CMTP |= 0x80;
            I2CMTP &= 0xFFFFFFBF;
        } else {
            I2CMTP = 74;
        }
        return I2CMTP;
    }

    int getMaxTransferSize(int[] pMaxSize) {
        pMaxSize[0] = 0;
        int maxBuckSize = this.mFt4222Dev.getMaxBuckSize();
        switch (this.mFt4222Dev.mChipStatus.function) {
            case 1: {
                pMaxSize[0] = maxBuckSize - 4;
                break;
            }
            default: {
                return 17;
            }
        }
        return 0;
    }

    int getFWVersion(char[] ver) {
        byte[] bVer = new byte[12];
        int ftStatus = this.mFtDev.VendorCmdGet(32, 0, bVer, 12);
        if (ftStatus < 0) {
            return 18;
        }
        if (bVer[2] == 1) {
            ver[0] = 65;
        } else if (bVer[2] == 2) {
            ver[0] = 66;
        }
        return 0;
    }
}

