/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.FtVidPid;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class D2xxManager {
    private static D2xxManager mInstance = null;
    private static final String TAG = "D2xx::";
    protected static final String ACTION_USB_PERMISSION = "com.ftdi.j2xx";
    public static final byte FT_DATA_BITS_7 = 7;
    public static final byte FT_DATA_BITS_8 = 8;
    public static final byte FT_STOP_BITS_1 = 0;
    public static final byte FT_STOP_BITS_2 = 2;
    public static final byte FT_PARITY_NONE = 0;
    public static final byte FT_PARITY_ODD = 1;
    public static final byte FT_PARITY_EVEN = 2;
    public static final byte FT_PARITY_MARK = 3;
    public static final byte FT_PARITY_SPACE = 4;
    public static final short FT_FLOW_NONE = 0;
    public static final short FT_FLOW_RTS_CTS = 256;
    public static final short FT_FLOW_DTR_DSR = 512;
    public static final short FT_FLOW_XON_XOFF = 1024;
    public static final byte FT_PURGE_RX = 1;
    public static final byte FT_PURGE_TX = 2;
    public static final byte FT_CTS = 16;
    public static final byte FT_DSR = 32;
    public static final byte FT_RI = 64;
    public static final byte FT_DCD = -128;
    public static final byte FT_OE = 2;
    public static final byte FT_PE = 4;
    public static final byte FT_FE = 8;
    public static final byte FT_BI = 16;
    public static final byte FT_EVENT_RXCHAR = 1;
    public static final byte FT_EVENT_MODEM_STATUS = 2;
    public static final byte FT_EVENT_LINE_STATUS = 4;
    public static final byte FT_EVENT_REMOVED = 8;
    public static final byte FT_FLAGS_OPENED = 1;
    public static final byte FT_FLAGS_HI_SPEED = 2;
    public static final int FT_DEVICE_232B = 0;
    public static final int FT_DEVICE_8U232AM = 1;
    public static final int FT_DEVICE_UNKNOWN = 3;
    public static final int FT_DEVICE_2232 = 4;
    public static final int FT_DEVICE_232R = 5;
    public static final int FT_DEVICE_245R = 5;
    public static final int FT_DEVICE_2232H = 6;
    public static final int FT_DEVICE_4232H = 7;
    public static final int FT_DEVICE_232H = 8;
    public static final int FT_DEVICE_X_SERIES = 9;
    public static final int FT_DEVICE_4222_0 = 10;
    public static final int FT_DEVICE_4222_1_2 = 11;
    public static final int FT_DEVICE_4222_3 = 12;
    public static final byte FT_BITMODE_RESET = 0;
    public static final byte FT_BITMODE_ASYNC_BITBANG = 1;
    public static final byte FT_BITMODE_MPSSE = 2;
    public static final byte FT_BITMODE_SYNC_BITBANG = 4;
    public static final byte FT_BITMODE_MCU_HOST = 8;
    public static final byte FT_BITMODE_FAST_SERIAL = 16;
    public static final byte FT_BITMODE_CBUS_BITBANG = 32;
    public static final byte FT_BITMODE_SYNC_FIFO = 64;
    public static final int FTDI_BREAK_OFF = 0;
    public static final int FTDI_BREAK_ON = 16384;
    private static Context mContext = null;
    private static PendingIntent mPendingIntent = null;
    private static IntentFilter mPermissionFilter = null;
    private static List<FtVidPid> mSupportedDevices = new ArrayList<FtVidPid>(Arrays.asList(new FtVidPid(1027, 24597), new FtVidPid(1027, 24596), new FtVidPid(1027, 24593), new FtVidPid(1027, 24592), new FtVidPid(1027, 24577), new FtVidPid(1027, 24582), new FtVidPid(1027, 24604), new FtVidPid(1027, 64193), new FtVidPid(1027, 64194), new FtVidPid(1027, 64195), new FtVidPid(1027, 64196), new FtVidPid(1027, 64197), new FtVidPid(1027, 64198), new FtVidPid(1027, 24594), new FtVidPid(2220, 4133), new FtVidPid(5590, 1), new FtVidPid(1027, 24599)));
    private ArrayList<FT_Device> mFtdiDevices;
    private static UsbManager mUsbManager;
    private BroadcastReceiver mUsbPlugEvents = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            UsbDevice dev = null;
            FT_Device ftDev = null;
            if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                dev = (UsbDevice)intent.getParcelableExtra("device");
                ftDev = D2xxManager.this.findDevice(dev);
                while (ftDev != null) {
                    ftDev.close();
                    ArrayList arrayList = D2xxManager.this.mFtdiDevices;
                    synchronized (arrayList) {
                        D2xxManager.this.mFtdiDevices.remove(ftDev);
                    }
                    ftDev = D2xxManager.this.findDevice(dev);
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                dev = (UsbDevice)intent.getParcelableExtra("device");
                D2xxManager.this.addUsbDevice(dev);
            }
        }
    };
    private static BroadcastReceiver mUsbDevicePermissions;

    static {
        mUsbDevicePermissions = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (D2xxManager.ACTION_USB_PERMISSION.equals(action)) {
                    2 var4_4 = this;
                    synchronized (var4_4) {
                        UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                        if (!intent.getBooleanExtra("permission", false)) {
                            Log.d((String)D2xxManager.TAG, (String)("permission denied for device " + device));
                        }
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FT_Device findDevice(UsbDevice usbDev) {
        FT_Device rtDev = null;
        ArrayList<FT_Device> arrayList = this.mFtdiDevices;
        synchronized (arrayList) {
            int nr_dev = this.mFtdiDevices.size();
            int i = 0;
            while (i < nr_dev) {
                FT_Device ftDevice = this.mFtdiDevices.get(i);
                UsbDevice dev = ftDevice.getUsbDevice();
                if (dev.equals((Object)usbDev)) {
                    rtDev = ftDevice;
                    break;
                }
                ++i;
            }
        }
        return rtDev;
    }

    public boolean isFtDevice(UsbDevice dev) {
        boolean rc = false;
        if (mContext == null) {
            return rc;
        }
        FtVidPid vidPid = new FtVidPid(dev.getVendorId(), dev.getProductId());
        if (mSupportedDevices.contains(vidPid)) {
            rc = true;
        }
        Log.v((String)TAG, (String)vidPid.toString());
        return rc;
    }

    private static synchronized boolean updateContext(Context context) {
        boolean rc = false;
        if (context == null) {
            return rc;
        }
        if (mContext != context) {
            mContext = context;
            mPendingIntent = PendingIntent.getBroadcast((Context)mContext.getApplicationContext(), (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0x8000000);
            mPermissionFilter = new IntentFilter(ACTION_USB_PERMISSION);
            mContext.getApplicationContext().registerReceiver(mUsbDevicePermissions, mPermissionFilter);
        }
        rc = true;
        return rc;
    }

    private boolean isPermitted(UsbDevice dev) {
        boolean rc = false;
        if (!mUsbManager.hasPermission(dev)) {
            mUsbManager.requestPermission(dev, mPendingIntent);
        }
        if (mUsbManager.hasPermission(dev)) {
            rc = true;
        }
        return rc;
    }

    private D2xxManager(Context parentContext) throws D2xxException {
        Log.v((String)TAG, (String)"Start constructor");
        if (parentContext == null) {
            throw new D2xxException("D2xx init failed: Can not find parentContext!");
        }
        D2xxManager.updateContext(parentContext);
        if (!D2xxManager.findUsbManger()) {
            throw new D2xxException("D2xx init failed: Can not find UsbManager!");
        }
        this.mFtdiDevices = new ArrayList();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        parentContext.getApplicationContext().registerReceiver(this.mUsbPlugEvents, filter);
        Log.v((String)TAG, (String)"End constructor");
    }

    public static synchronized D2xxManager getInstance(Context parentContext) throws D2xxException {
        if (mInstance == null) {
            mInstance = new D2xxManager(parentContext);
        }
        if (parentContext != null) {
            D2xxManager.updateContext(parentContext);
        }
        return mInstance;
    }

    private static boolean findUsbManger() {
        if (mUsbManager == null && mContext != null) {
            mUsbManager = (UsbManager)mContext.getApplicationContext().getSystemService("usb");
        }
        return mUsbManager != null;
    }

    public boolean setVIDPID(int vendorId, int productId) {
        boolean rc = false;
        if (vendorId != 0 && productId != 0) {
            FtVidPid vidpid = new FtVidPid(vendorId, productId);
            if (mSupportedDevices.contains(vidpid)) {
                Log.i((String)TAG, (String)("Existing vid:" + vendorId + "  pid:" + productId));
                return true;
            }
            if (!mSupportedDevices.add(vidpid)) {
                Log.d((String)TAG, (String)"Failed to add VID/PID combination to list.");
            } else {
                rc = true;
            }
        } else {
            Log.d((String)TAG, (String)"Invalid parameter to setVIDPID");
        }
        return rc;
    }

    public int[][] getVIDPID() {
        int listSize = mSupportedDevices.size();
        int[][] arrayVIDPID = new int[2][listSize];
        int i = 0;
        while (i < listSize) {
            FtVidPid vidpid = mSupportedDevices.get(i);
            arrayVIDPID[0][i] = vidpid.getVid();
            arrayVIDPID[1][i] = vidpid.getPid();
            ++i;
        }
        return arrayVIDPID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDevices() {
        ArrayList<FT_Device> arrayList = this.mFtdiDevices;
        synchronized (arrayList) {
            int nr_dev = this.mFtdiDevices.size();
            int i = 0;
            while (i < nr_dev) {
                this.mFtdiDevices.remove(0);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createDeviceInfoList(Context parentContext) {
        HashMap deviceList = mUsbManager.getDeviceList();
        Iterator deviceIterator = deviceList.values().iterator();
        ArrayList<FT_Device> devices = new ArrayList<FT_Device>();
        FT_Device ftDev = null;
        int rc = 0;
        if (parentContext == null) {
            return rc;
        }
        D2xxManager.updateContext(parentContext);
        while (deviceIterator.hasNext()) {
            UsbDevice usbDevice = (UsbDevice)deviceIterator.next();
            if (!this.isFtDevice(usbDevice)) continue;
            int numInterfaces = 0;
            numInterfaces = usbDevice.getInterfaceCount();
            int i = 0;
            while (i < numInterfaces) {
                if (this.isPermitted(usbDevice)) {
                    ArrayList<FT_Device> arrayList = this.mFtdiDevices;
                    synchronized (arrayList) {
                        ftDev = this.findDevice(usbDevice);
                        if (ftDev == null) {
                            ftDev = new FT_Device(parentContext, mUsbManager, usbDevice, usbDevice.getInterface(i));
                        } else {
                            this.mFtdiDevices.remove(ftDev);
                            ftDev.setContext(parentContext);
                        }
                        devices.add(ftDev);
                    }
                }
                ++i;
            }
        }
        ArrayList<FT_Device> arrayList = this.mFtdiDevices;
        synchronized (arrayList) {
            this.clearDevices();
            this.mFtdiDevices = devices;
            rc = this.mFtdiDevices.size();
        }
        return rc;
    }

    public synchronized int getDeviceInfoList(int numDevs, FtDeviceInfoListNode[] deviceList) {
        int i = 0;
        while (i < numDevs) {
            deviceList[i] = this.mFtdiDevices.get((int)i).mDeviceInfoNode;
            ++i;
        }
        return this.mFtdiDevices.size();
    }

    public synchronized FtDeviceInfoListNode getDeviceInfoListDetail(int index) {
        if (index > this.mFtdiDevices.size() || index < 0) {
            return null;
        }
        return this.mFtdiDevices.get((int)index).mDeviceInfoNode;
    }

    public static int getLibraryVersion() {
        return 0x20400000;
    }

    private boolean tryOpen(Context parentContext, FT_Device ftDev, DriverParameters params) {
        boolean rc = false;
        if (ftDev == null) {
            return rc;
        }
        if (parentContext == null) {
            return rc;
        }
        ftDev.setContext(parentContext);
        if (params != null) {
            ftDev.setDriverParameters(params);
        }
        if (ftDev.openDevice(mUsbManager) && ftDev.isOpen()) {
            rc = true;
        }
        return rc;
    }

    public synchronized FT_Device openByUsbDevice(Context parentContext, UsbDevice dev, DriverParameters params) {
        FT_Device ftDev = null;
        if (this.isFtDevice(dev) && !this.tryOpen(parentContext, ftDev = this.findDevice(dev), params)) {
            ftDev = null;
        }
        return ftDev;
    }

    public synchronized FT_Device openByUsbDevice(Context parentContext, UsbDevice dev) {
        return this.openByUsbDevice(parentContext, dev, null);
    }

    public synchronized FT_Device openByIndex(Context parentContext, int index, DriverParameters params) {
        FT_Device ftDev = null;
        if (index < 0) {
            return ftDev;
        }
        if (parentContext == null) {
            return ftDev;
        }
        D2xxManager.updateContext(parentContext);
        ftDev = this.mFtdiDevices.get(index);
        if (!this.tryOpen(parentContext, ftDev, params)) {
            ftDev = null;
        }
        return ftDev;
    }

    public synchronized FT_Device openByIndex(Context parentContext, int index) {
        return this.openByIndex(parentContext, index, null);
    }

    public synchronized FT_Device openBySerialNumber(Context parentContext, String serialNumber, DriverParameters params) {
        FtDeviceInfoListNode devInfo = null;
        FT_Device ftDev = null;
        if (parentContext == null) {
            return ftDev;
        }
        D2xxManager.updateContext(parentContext);
        int i = 0;
        while (i < this.mFtdiDevices.size()) {
            FT_Device tmpDev = this.mFtdiDevices.get(i);
            if (tmpDev != null) {
                devInfo = tmpDev.mDeviceInfoNode;
                if (devInfo == null) {
                    Log.d((String)TAG, (String)"***devInfo cannot be null***");
                } else if (devInfo.serialNumber.equals(serialNumber)) {
                    ftDev = tmpDev;
                    break;
                }
            }
            ++i;
        }
        if (!this.tryOpen(parentContext, ftDev, params)) {
            ftDev = null;
        }
        return ftDev;
    }

    public synchronized FT_Device openBySerialNumber(Context parentContext, String serialNumber) {
        return this.openBySerialNumber(parentContext, serialNumber, null);
    }

    public synchronized FT_Device openByDescription(Context parentContext, String description, DriverParameters params) {
        FtDeviceInfoListNode devInfo = null;
        FT_Device ftDev = null;
        if (parentContext == null) {
            return ftDev;
        }
        D2xxManager.updateContext(parentContext);
        int i = 0;
        while (i < this.mFtdiDevices.size()) {
            FT_Device tmpDev = this.mFtdiDevices.get(i);
            if (tmpDev != null) {
                devInfo = tmpDev.mDeviceInfoNode;
                if (devInfo == null) {
                    Log.d((String)TAG, (String)"***devInfo cannot be null***");
                } else if (devInfo.description.equals(description)) {
                    ftDev = tmpDev;
                    break;
                }
            }
            ++i;
        }
        if (!this.tryOpen(parentContext, ftDev, params)) {
            ftDev = null;
        }
        return ftDev;
    }

    public synchronized FT_Device openByDescription(Context parentContext, String description) {
        return this.openByDescription(parentContext, description, null);
    }

    public synchronized FT_Device openByLocation(Context parentContext, int location, DriverParameters params) {
        FtDeviceInfoListNode devInfo = null;
        FT_Device ftDev = null;
        if (parentContext == null) {
            return ftDev;
        }
        D2xxManager.updateContext(parentContext);
        int i = 0;
        while (i < this.mFtdiDevices.size()) {
            FT_Device tmpDev = this.mFtdiDevices.get(i);
            if (tmpDev != null) {
                devInfo = tmpDev.mDeviceInfoNode;
                if (devInfo == null) {
                    Log.d((String)TAG, (String)"***devInfo cannot be null***");
                } else if (devInfo.location == location) {
                    ftDev = tmpDev;
                    break;
                }
            }
            ++i;
        }
        if (!this.tryOpen(parentContext, ftDev, params)) {
            ftDev = null;
        }
        return ftDev;
    }

    public synchronized FT_Device openByLocation(Context parentContext, int location) {
        return this.openByLocation(parentContext, location, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addUsbDevice(UsbDevice dev) {
        int rc = 0;
        if (this.isFtDevice(dev)) {
            int numInterfaces = 0;
            numInterfaces = dev.getInterfaceCount();
            int i = 0;
            while (i < numInterfaces) {
                if (this.isPermitted(dev)) {
                    ArrayList<FT_Device> arrayList = this.mFtdiDevices;
                    synchronized (arrayList) {
                        FT_Device ftDev = this.findDevice(dev);
                        if (ftDev == null) {
                            ftDev = new FT_Device(mContext, mUsbManager, dev, dev.getInterface(i));
                        } else {
                            ftDev.setContext(mContext);
                            this.mFtdiDevices.remove(ftDev);
                        }
                        this.mFtdiDevices.add(ftDev);
                        ++rc;
                    }
                }
                ++i;
            }
        }
        return rc;
    }

    public static class D2xxException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public D2xxException() {
        }

        public D2xxException(String ftStatusMsg) {
            super(ftStatusMsg);
        }
    }

    public static class DriverParameters {
        private int mBufferSize = 16384;
        private int mMaxTransferSize = 16384;
        private int mNrBuffers = 16;
        private int mRxTimeout = 5000;

        public boolean setMaxBufferSize(int size) {
            boolean rc = false;
            if (size >= 64 && size <= 262144) {
                this.mBufferSize = size;
                rc = true;
            } else {
                Log.e((String)D2xxManager.TAG, (String)"***bufferSize Out of correct range***");
            }
            return rc;
        }

        public int getMaxBufferSize() {
            return this.mBufferSize;
        }

        public boolean setMaxTransferSize(int size) {
            boolean rc = false;
            if (size >= 64 && size <= 262144) {
                this.mMaxTransferSize = size;
                rc = true;
            } else {
                Log.e((String)D2xxManager.TAG, (String)"***maxTransferSize Out of correct range***");
            }
            return rc;
        }

        public int getMaxTransferSize() {
            return this.mMaxTransferSize;
        }

        public boolean setBufferNumber(int number) {
            boolean rc = false;
            if (number >= 2 && number <= 16) {
                this.mNrBuffers = number;
                rc = true;
            } else {
                Log.e((String)D2xxManager.TAG, (String)"***nrBuffers Out of correct range***");
            }
            return rc;
        }

        public int getBufferNumber() {
            return this.mNrBuffers;
        }

        public boolean setReadTimeout(int timeout) {
            this.mRxTimeout = timeout;
            return true;
        }

        public int getReadTimeout() {
            return this.mRxTimeout;
        }
    }

    public static class FtDeviceInfoListNode {
        public int flags;
        public short bcdDevice;
        public int type;
        public byte iSerialNumber;
        public int id;
        public int location;
        public String serialNumber;
        public String description;
        public int handle;
        public int breakOnParam;
        public short modemStatus;
        public short lineStatus;
    }
}

